<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
require('connect.php');


if(!isset($_POST['email'])){
    echo json_encode(['status'=>'failed', 'data'=>"email not set"]);
    return;
}

$datetime = date("Y-m-d H:i:s");


$email = mysqli_real_escape_string($conn, $_POST['email']);
$type = mysqli_real_escape_string($conn, $_POST['idtype']);
$idnumber = mysqli_real_escape_string($conn, $_POST['idnumber']);
$country = mysqli_real_escape_string($conn, $_POST['country']);

$target_dir = "kyc/";
$front = $_FILES["image"]["name"];
$image_tmp = $_FILES["image"]["tmp_name"];
$image_size = $_FILES["image"]["size"];

$imageFileType = strtolower(pathinfo($front, PATHINFO_EXTENSION));
$allowedTypes = ['jpg', 'jpeg', 'png'];

$frontname = $email . '_' . uniqid() . '.' . $imageFileType;
$target_file = $target_dir . $frontname;

$uploadOk = 1;
$err = "no error";

$check = getimagesize($image_tmp);
if ($check === false) {
    $err = "File is not a valid image.";
    $uploadOk = 0;
}

// Validate file size
if ($image_size > 5 * 1024 * 1024) { // 5MB
    $err = "Sorry, your file is too large.";
    $uploadOk = 0;
}

// Validate file extension
if (!in_array($imageFileType, $allowedTypes)) {
    $err = "Sorry, only JPG, JPEG & PNG files are allowed.";
    $uploadOk = 0;
}

if ($uploadOk == 0) {
    echo json_encode(['status' => 'failed', 'data' => "Sorry, your file was not uploaded. ". $err]);

} else {
    move_uploaded_file($image_tmp, $target_file);
    
   mysqli_query($conn, "delete from kyc where email = '$email'");
   mysqli_query($conn, "insert into kyc(id,email,type,image,idnumber,datetime,status,country)  values(0,'$email','$type','$frontname','$idnumber','$datetime',0,'$country')");
    echo json_encode(['status' => 'success', 'data' => "success"]);

}

