<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

require('connect.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $address = $_POST['image_address'] ?? '';
    $asset = $_POST['image_name'] ?? '';
    $uploadDir = 'qrcodes/';
    $imageFileName = '';

    // Validate required fields
    if (empty($address) || empty($asset)) {
        echo json_encode(['status' => 'error', 'message' => 'Missing required fields.']);
        exit;
    }

    // Check if a file was uploaded
    if (isset($_FILES['image_file']) && $_FILES['image_file']['error'] === UPLOAD_ERR_OK) {
        $tmpName = $_FILES['image_file']['tmp_name'];
        $originalName = basename($_FILES['image_file']['name']);
        $ext = pathinfo($originalName, PATHINFO_EXTENSION);
        $imageFileName = uniqid('qr_', true) . '.' . $ext;
        $destination = $uploadDir . $imageFileName;

        if (!move_uploaded_file($tmpName, $destination)) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to upload image.']);
            exit;
        }

        // Update with image
        $stmt = $conn->prepare("UPDATE wallet_address SET walletaddress = ?, qrcode = ? WHERE asset = ?");
        $stmt->bind_param("sss", $address, $imageFileName, $asset);
    } else {
        // Update without image
        $stmt = $conn->prepare("UPDATE wallet_address SET walletaddress = ? WHERE asset = ?");
        $stmt->bind_param("ss", $address, $asset);
    }

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Record updated successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update record.']);
    }

    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>

?>
