<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

require 'connect.php';


function getRemoteContent($url)
{
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $data = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception('cURL error: ' . curl_error($ch));
    }

    curl_close($ch);
    return $data;
}



$content = getRemoteContent('https://bitpay.com/api/rates');
$json = json_decode($content);

foreach ($json as $obj) {
    if ($obj->code == 'USD') {
        $btc = $obj->rate;
    }

    if ($obj->code == 'ETH') {
        $eth = (1 / $obj->rate) * $btc;
    }
    if ($obj->code == 'DOGE') {
        $doge = (1 / $obj->rate) * $btc;
    }
}



function getTronPrice()
{
    $url = 'https://api.diadata.org/v1/assetQuotation/Tron/0x0000000000000000000000000000000000000000';
    $content = getRemoteContent($url);
    $data = json_decode($content, true);


    return $data['Price'];
}



$tron = getTronPrice();


$page = isset($_GET['page']) && $_GET['page'] > 0 ? $_GET['page'] : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

$query = "SELECT COUNT(*) AS total FROM users ";
$result = mysqli_query($conn, $query);
$totalRecords = mysqli_fetch_assoc($result)['total'];
$totalPages = ceil($totalRecords / $limit);

if (isset($_GET['search'])) {
    $searchQuery = $_GET['search'];
    $stmt = mysqli_query($conn, "SELECT * FROM users where email LIKE '%$searchQuery%' or id LIKE '%$searchQuery%' ORDER BY DATETIME DESC ");
} else {
    $stmt = mysqli_query($conn, "SELECT * FROM users ORDER BY DATETIME DESC LIMIT $limit OFFSET $offset");
}



$arr = array();
$cnt = 0;


while ($row = mysqli_fetch_assoc($stmt)) {
    $cnt += 1;
    $email = $row['email'];
    $totalbal = 0;

    $myy = mysqli_query($conn, "select value, quantity from transaction where sender_email = 'service@eleganex.com' and receiver_email = '$email' and asset = 'TRON' ORDER BY ID DESC LIMIT 1 ");
    if (mysqli_num_rows($myy) > 0) {
        if ($rowy = mysqli_fetch_assoc($myy)) {
            $val = $rowy['value'];
            $qu = $rowy['quantity'];

            $tron = $val / $qu;
        }
    }

    $qu = mysqli_query($conn, "select id, name, balance from assets where user = '$email'");
    while ($row2 = mysqli_fetch_assoc($qu)) {
        if ($row2['name'] == "BITCOIN") {
            $totalbal += ($row2['balance'] * $btc);
        }
        if ($row2['name'] == "ETHEREUM") {
            $totalbal += ($row2['balance'] * $eth);
        }
        if ($row2['name'] == "DOGE") {
            $totalbal += ($row2['balance'] * $doge);
        }
        if ($row2['name'] == "TRON") {
            $totalbal += ($row2['balance'] * $tron);
        }
        if ($row2['name'] == "USDT_TRC20") {
            $totalbal += ($row2['balance']);
        }
        if ($row2['name'] == "USDT_ERC20") {
            $totalbal += ($row2['balance']);
        }
    }
    $mk = mysqli_query($conn, "select id from kyc where email = '$email'");
    if (mysqli_num_rows($mk) > 0) {

    }
    $totalbal = number_format(round($totalbal, 2), 2);
    $arr[] = array('cnt' => $cnt, 'email' => $row['email'], 'tbal' => $totalbal, 'fullname' => $row['fullname'], 'emailverified' => $row['emailverified'], 'phone' => $row['phone']);
}

echo json_encode(array('data' => $arr, 'totalpages' => $totalPages));


