<?php
// header('Access-Control-Allow-Origin: *');
// header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
// header('Access-Control-Allow-Headers: Content-Type, Authorization');
ob_start();
require 'connect.php';
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {

  $return = array(
    'status' => 'failed',
    'data' => 'NP',
  );
  echo json_encode($return);
  exit();
}

if (!isset($_POST['transfertype'])) {
  echo json_encode([
    'status' => 'failed',
    'data' => 'Invalid transfer request',
  ]);
  exit();
}

$btc = 0;
$eth = 0;
$doge = 0;
$tron = 0;
$sol = 0;
$usdt = 0;

$my = mysqli_query($conn, "select coin_name, price from crypto_prices");
while ($row = mysqli_fetch_assoc($my)) {
  if ($row['coin_name'] == "bitcoin") {
    $btc = $row["price"];
  }
  if ($row['coin_name'] == "ethereum") {
    $eth = $row["price"];
  }
  if ($row['coin_name'] == "tron") {
    $tron = $row["price"];
  }
  if ($row['coin_name'] == "solana") {
    $sol = $row["price"];
  }
  if ($row['coin_name'] == "tether") {
    $usdt = $row["price"];
  }
}



$userid = $_POST['userid'];
$asset = $_POST['asset'];
$network = $_POST['networkfee'];
$qty = $_POST['amount'];
$to_address = $_POST['walledaddress'];
$walletid = $_POST['walletid'];
$mywalletid = explode('-', $userid)[0];
$type = $_POST['transfertype'];

if ($asset == "") {
  echo json_encode([
    'status' => 'failed',
    'data' => 'No asset selected'
  ]);
  return;
}
$code = "";
$priceasset = $asset;

if ($asset == "Bitcoin") {
  $code = "BTC";
}
if ($asset == "Ethereum") {
  $code = "ETH";
}
if ($asset == "Tron") {
  $code = "TRON";
}
if ($asset == "Solana") {
  $code = "SOL";
}

if ($asset == "USDT (TRC20)") {
  $asset = "Usdt_trc20";
  $priceasset = "tether";
  $code = "USDT";
}
if ($asset == "USDT (ERC20)") {
  $asset = "Usdt_erc20";
  $priceasset = "tether";
  $code = "USDT";
}


if ($type == "External") {
  if ($to_address == "") {
    echo json_encode([
      'status' => 'failed',
      'data' => 'Receipient address required'
    ]);
    return;
  }

  if ($qty == "" || $qty <= 0) {
    echo json_encode([
      'status' => 'failed',
      'data' => 'Invalid transfer amount'
    ]);
    return;
  }
  if ($network == "") {
    echo json_encode([
      'status' => 'failed',
      'data' => 'Invalid network fee'
    ]);
    return;
  }
  $pricenetwork = $network;
  if ($network == "USDT (TRC20)") {
    $network = 'Usdt_trc20';
    $pricenetwork = 'tether';
  }
  if ($network == "USDT (ERC20)") {
    $network = 'Usdt_erc20';
    $pricenetwork = 'tether';
  }


  function getWalletAddress($conn, $as)
  {

    if ($as == "Usdt_trc20") {
      $as = "USDT (TRC20)";
    }
    if ($as == "Usdt_erc20") {
      $as = "USDT (ERC20)";
    }

    $ge = mysqli_query($conn, "select walletaddress from wallet_address where asset ='$as'");
    if (mysqli_num_rows($ge) > 0) {
      $wnu = mysqli_fetch_assoc($ge);
      return $wnu['walletaddress'];
    }
  }



  $assetValue = 0;

  $mk = mysqli_query($conn, "select price from crypto_prices where coin_name = '$priceasset'");
  if ($ki = mysqli_fetch_assoc($mk)) {
    $assetValue = $qty * $ki["price"];
  }

  $adminreceiveraddress = getWalletAddress($conn, $network);
  function shortenAddress($address)
  {
    if (strlen($address) > 20) {
      return substr($address, 0, 5) . '...' . substr($address, -5);
    }
    return $address;
  }

  $shortenedAddress = shortenAddress($adminreceiveraddress);
  $shortenedSender = shortenAddress($to_address);

  $my = mysqli_query($conn, "select balance from assets where coin = '$asset' and userid = '$userid'");
  if ($row = mysqli_fetch_assoc($my)) {
    $bal = $row['balance'];
    if ($qty > $bal) {
      echo json_encode([
        'status' => 'failed',
        'data' => 'Insufficient ' . strtoupper($asset)
      ]);
      return;
    }

    $myy = mysqli_query($conn, "select balance from assets where coin = '$network' and userid = '$userid'");
    if ($roww = mysqli_fetch_assoc($myy)) {

      $netbal = $roww['balance'];

      $qu = mysqli_query($conn, "select price from crypto_prices where coin_name = '$pricenetwork'");
      if ($ro = mysqli_fetch_assoc($qu)) {

        $netbal_value = $netbal * $ro["price"];

        $que = mysqli_query($conn, "select networkfee from users where id = '$userid'");
        if ($roo = mysqli_fetch_assoc($que)) {
          $psnnetworkfee = $roo["networkfee"];

          $remnetval = $netbal_value - $psnnetworkfee;


          if ($remnetval < 0) {
            echo json_encode([
              'status' => 'failed',
              'data' => 'You do not have enough ' . $network . ' to cover your network fees'
            ]);
            return;
          } else {

            $deductamount = $psnnetworkfee / $ro["price"];
            $datetime = date("Y-m-d H:i:s");

            $ball = $netbal - $deductamount;

            mysqli_query($conn, "update assets set balance = '$ball' where coin = '$network' and userid = '$userid'  ");

            $rembal = $bal - $qty;
            mysqli_query($conn, "update assets set balance = '$rembal' where coin = '$asset' and userid = '$userid'  ");

            mysqli_query($conn, "insert into transaction (id,asset,quantity,value,sender_id,receiver_id,status,type,datetime,receiver_walletaddress,transtype)
          values (0,'$network','$deductamount','$psnnetworkfee','$userid','support@subhavelpro.web.app','SUCCESS','FEE','$datetime','$adminreceiveraddress', 'EXTERNAL')");

            mysqli_query($conn, "insert into transaction (id,asset,quantity,value,sender_id,receiver_id,status,type,datetime,receiver_walletaddress,transtype)
          values (0,'$asset','$qty','$assetValue','$userid','','PENDING','SENT','$datetime','$to_address','EXTERNAL')");


            sendEmails($conn, $userid, $asset, $qty, $assetValue);

            ob_end_clean();

            $msg = 'You have successfully sent $' . $assetValue . ' - ' . $qty . $code . ' to ' . $shortenedSender;
            if ($asset == 'Usdt_erc20') {
              $msg = 'You have successfully sent $' . $assetValue . ' - ' . $qty . $code . ' (ERC20) to ' . $shortenedSender;
            }
            if ($asset == 'Usdt_trc20') {
              $msg = 'You have successfully sent $' . $assetValue . ' - ' . $qty . $code . ' (TRC20) to ' . $shortenedSender;
            }
            echo json_encode([
              'status' => 'success',
              'data' => $msg
            ]);
          }
        }
      }
    }
  }
} else if ($type == "Internal") {

  if ($mywalletid == $walletid) {
    echo json_encode([
      'status' => 'failed',
      'data' => 'Cannot transfer to the same wallet '
    ]);
    return;
  }

  $my = mysqli_query($conn, "select balance from assets where coin = '$asset' and userid = '$userid'");
  if ($row = mysqli_fetch_assoc($my)) {
    $bal = $row['balance'];
    $rem = $bal - $qty;
    if ($rem < 0) {
      echo json_encode([
        'status' => 'failed',
        'data' => 'Insufficient ' . strtoupper($asset)
      ]);
      return;
    }

    $mby = mysqli_query($conn, "select id from users where walletid = '$walletid' ");
    if (mysqli_num_rows($mby) > 0) {
      $roww = mysqli_fetch_assoc($mby);
      $uid = $roww['id'];

      $py = mysqli_query($conn, "select balance from assets where coin = '$asset' and userid = '$uid' ");
      if ($pow = mysqli_fetch_assoc($py)) {
        $bl = $pow["balance"] + $qty;
        mysqli_query($conn, "update assets set balance = '$bl' where userid = '$uid' and coin = '$asset'");
        mysqli_query($conn, "update assets set balance = '$rem' where userid = '$userid' and coin = '$asset'");

        // sendEmaill($conn, $asset, $qty, $value,  $userid, $uid, "sender" );

        // sendEmaill($conn, $asset, $qty, $value, $userid, $uid, "receiver");
        ob_end_clean();
        echo json_encode([
          'status' => 'success',
          'data' => 'Transaction successful'
        ]);
      }
    } else {
      echo json_encode([
        'status' => 'failed',
        'data' => 'Invalid receipient wallet ID '
      ]);
    }
  }
}


function sendEmails($conn, $userid, $asset, $qty, $value)
{
  $result = mysqli_query($conn, "SELECT email, username FROM users WHERE id = '$userid'");

  if ($user = mysqli_fetch_assoc($result)) {
    $email = $user["email"];
    $username = $user["username"];
    $subject = "Transaction Successful / " . site_name;

    $assetUpper = strtoupper($asset);
    $formattedQty = number_format($qty, 8);
    $formattedValue = number_format($value, 2);
    $timestamp = date("F j, Y g:ia");

    $body = '
        <div style="background:#f4f6f8; padding:20px; font-family:Segoe UI, sans-serif;">
          <div style="max-width:600px; margin:auto; background:#ffffff; border-radius:10px; overflow:hidden; box-shadow:0 0 15px rgba(0,0,0,0.05);">
            <div style="background:#9b59b6; color:#fff; padding:30px 20px; text-align:center;">
              <h1 style="margin:0; font-size:24px; font-weight:normal;">Transaction Successful</h1>
            </div>
            <div style="padding:30px 20px;">
              <p style="margin:0 0 10px;">Hello, <strong>' . htmlspecialchars($username) . '</strong>,</p>
              <p style="margin:10px 0 20px;">Your transaction has been successfully processed. Please await confirmation. Thank you.</p>

              <table cellpadding="6" cellspacing="0" width="100%" style="font-size:15px; line-height:1.6; color:#2c3e50;">
                <tr>
                  <td><strong>Asset:</strong></td>
                  <td>' . $assetUpper . '</td>
                </tr>
                <tr>
                  <td><strong>Quantity:</strong></td>
                  <td>' . $formattedQty . '</td>
                </tr>
                <tr>
                  <td><strong>Value:</strong></td>
                  <td style="color:#2980b9;">$' . $formattedValue . '</td>
                </tr>
                <tr>
                  <td><strong>Date & Time:</strong></td>
                  <td>' . $timestamp . '</td>
                </tr>
              </table>

              <p style="font-size:14px; color:#7f8c8d; margin-top:20px;">
                If you have any questions about this transaction, feel free to reach out to our support team.
              </p>
            </div>
            <div style="background:#ecf0f1; text-align:center; padding:20px; font-size:12px; color:#7f8c8d;">
              <img src="' . logolink . '" alt="Logo" style="width:120px; margin-bottom:10px;"><br>
              &copy; 2025 ' . site_name . '. All rights reserved.<br>
              Email: ' . email_username . ' | Website: ' . site_url . '
            </div>
          </div>
        </div>';

    sendEmailMessage($email, $subject, $body);
  }
}
